<?php
session_start();
include 'conexao.php';

$nome = $_GET['nome'] ?? '';
$curso = $_GET['curso'] ?? '';
$ano = $_GET['ano'] ?? '';
$turno = $_GET['turno'] ?? '';
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Lista da Turma</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            margin: 0;
            background-color: #f4f6f9;
        }
        .sidebar {
            width: 260px;
            min-height: 100vh;
            background-color: #001f3f;
            color: white;
            position: fixed;
            top: 0;
            left: 0;
            padding-top: 60px;
        }
        .sidebar ul {
            list-style: none;
            padding: 0;
        }
        .sidebar li {
            padding: 12px 20px;
            cursor: pointer;
        }
        .sidebar li:hover {
            background-color: #0056b3;
        }
        .main-header {
            background-color: #003366;
            color: white;
            padding: 20px;
            margin-left: 260px;
            width: calc(100% - 260px);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: fixed;
            top: 0;
            z-index: 1000;
        }
        .content {
            margin-left: 260px;
            margin-top: 80px;
            padding: 20px;
        }
        .turma-info {
            background: white;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: bold;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 8px;
        }
        th, td {
            padding: 10px;
            border-bottom: 1px solid #ccc;
            }
            td:nth-child(2) {
            text-align: left;
        
        }
        th {
            background-color: #007bff;
            color: white;
        }
        .btn-pdf {
            background-color: #28a745;
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: bold;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <aside class="sidebar">
        <ul>
            <li onclick="window.location.href='painel.php'"><i class="fas fa-home"></i> Painel Principal</li>
            <li><i class="fas fa-layer-group"></i> Turmas</li>
            <li><i class="fas fa-user-graduate"></i> Alunos</li>
            <li><i class="fas fa-book"></i> Disciplinas</li>
        </ul>
    </aside>

    <div class="main-header">
        <div>Lista da Turma</div>
        <div>Usuário: <?= $_SESSION['usuario']['nome'] ?? 'Desconhecido' ?></div>
    </div>

    <div class="content">
        <form method="get" action="gerar_pdf_lista_turma.php">
            <input type="hidden" name="nome" value="<?= htmlspecialchars($nome) ?>">
            <input type="hidden" name="curso" value="<?= htmlspecialchars($curso) ?>">
            <input type="hidden" name="ano" value="<?= htmlspecialchars($ano) ?>">
            <input type="hidden" name="turno" value="<?= htmlspecialchars($turno) ?>">
            <button class="btn-pdf" type="submit"><i class="fas fa-print"></i> Imprimir PDF</button>
        </form>

        <div class="turma-info">
            Turma: <strong><?= htmlspecialchars($nome) ?></strong> |
            Curso: <strong><?= htmlspecialchars($curso) ?></strong> |
            Ano Letivo: <strong><?= htmlspecialchars($ano) ?></strong> |
            Período: <strong><?= htmlspecialchars($turno) ?></strong>
        </div>

        <table>
            <thead>
                <tr>
                    <th>N°</th>
                    <th>Nome</th>
                    <th>Idade</th>
                    <th>Género</th>
                </tr>
            </thead>
            <tbody>
                <?php



                $sql = "SELECT * FROM alunos WHERE turma_id = ? ORDER BY nome ASC";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("s", $nome);
                $stmt->execute();
                $result = $stmt->get_result();
                $i = 1;
                while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['nome']) ?></td>
                        <td><?= $row['idade'] ?></td>
                        <td><?= $row['genero'] ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>
</html>


